/*
 * @(#)AMAction.java  1.O  2006-12-16
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.am.model;

import ch.hslu.cm.simulation.*;
import ch.randelshofer.util.*;
import ch.hslu.cm.simulation.*;
import java.beans.*;
import java.io.IOException;
import javax.swing.event.*;
import java.util.*;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;

/**
 * Represents the MODEL (structural, behavioral representation) of an Action
 * element in an Activity Diagram.
 * <p>
 * An action may have sets of incoming and outgoing activity edges that specify
 * control flow to other nodes. An action will not begin execution until all of
 * its input conditions are satisfied. The completion of the execution of an
 * action may enable the execution of a set of successor nodes that take their
 * inputs from the outputs of the action.
 * <p>
 * Actions are notated as round-cornered rectangles. The name of the action or
 * other description of it may appear in the symbol.
 * <p>
 * For further information, consult the official UML
 * <a href="http://www.omg.org/docs/formal/05-07-04.pdf">online resource</a>
 * of the Object Management Group (OMG):<br>
 * Unified Modeling Language: Superstructure, version 2.0, formal/05-07-04,
 * page 301 et sqq.
 *
 * @author Florian Padrun
 * @version 1.0 2006-12-16 Created.
 */
public class AMAction extends AbstractElement implements DOMStorable {
    /** Name of the model. */
    private String name;
    
    /** Creates a new instance. */
    public AMAction() {
        ResourceBundleUtil labels = ActivityModel.labels;
        name = labels.getString("actionDefaultName");
    }
    
    /**
     * Sets the name of the model.
     * @param newValue String
     */
    public void setName(String newValue) {
        String oldValue = name;
        name = newValue;
        firePropertyChange("name", oldValue, newValue);
    }
    
    /**
     * Gets the name of the model.
     * @return name
     */
    public String getName() {
        return name;
    }
    
    /**
     * Returns an ID specifying the concept simulated by this element.
     * @return ACTION
     */
    public int getSimulatedConcept() {
        return ActivityModel.ACTION;
    }
    
    /**
     * Creates and returns a copy of the model object.
     * @return that
     */
    public AMAction clone() {
        AMAction that = (AMAction) super.clone();
        return that;
    }
    
    /**
     * Writes the model object in a persisten state.
     * @param out DOMOutput
     */
    public void write(DOMOutput out) throws IOException {
        out.addAttribute("name", name);
    }
    
    /**
     * Reads the persistent model object.
     * @param in DOMInput
     */
    public void read(DOMInput in) throws IOException {
        name = in.getAttribute("name", "Action");
    }
    
    /**
     * Checks if the object is equivalent and returns true if the that object is
     * of the same type, and has the same name.
     * @param o SimulatedObject
     */
    public boolean isEquivalent(SimulatedObject o) {
        if (super.isEquivalent(o) && (o instanceof AMAction)) {
            AMAction that = (AMAction) o;
            
            if (that.getName() == this.getName()) {
                return true;
            }
        }
        return false;
    }
}